# 💖 Makale Yazıcı - Sevgilim İçin

Bu özel web paneli, sevgilimin makalelerden aldığı alıntıları yapay zeka ile birleştirip güzel makaleler oluşturması için hazırlandı.

## 🚀 Nasıl Kullanılır?

### 1. İlk Kurulum
- `index.html` dosyasını tarayıcıda aç
- Sağ alt köşedeki ⚙️ ayarlar butonuna tıkla
- OpenAI API anahtarını gir ve kaydet

### 2. Alıntı Ekleme
- Sol paneldeki text alanına makaleden kopyaladığın alıntıyı yapıştır
- **"Alıntı Ekle"** butonuna tıkla veya **Ctrl+Enter** tuş kombinasyonunu kullan
- Alıntılar orta panelde sırayla görünecek

### 3. Alıntıları Düzenleme
- ⬆️ ⬇️ okları ile alıntıların sırasını değiştir
- 🗑️ çöp kutusu ile istemediğin alıntıları sil
- + butonu ile yeni alıntılar ekle

### 4. Makale Oluşturma
- Prompt ayarlarından istediğin yazım stilini seç:
  - **Yaratıcı**: Akıcı ve etkileyici
  - **Akademik**: Bilimsel ve objektif  
  - **Analitik**: Derinlemesine analiz
- **"Makale Oluştur"** butonuna tıkla
- Yapay zeka alıntılarını birleştirip güzel bir makale yazacak

### 5. Makaleyi Kaydetme
- 📋 **Kopyala** butonu ile makaleyi panoya kopyala
- 💾 **İndir** butonu ile .txt dosyası olarak indir

## ✨ Özellikler

### 🎨 Güzel Tasarım
- Modern ve kullanıcı dostu arayüz
- Responsive tasarım (mobil uyumlu)
- Smooth animasyonlar ve geçişler

### 🤖 Yapay Zeka Entegrasyonu
- GPT-4 Omni (en gelişmiş model) kullanımı
- 3 farklı yazım stili seçeneği
- Özel prompt yazabilme imkanı

### 💾 Akıllı Saklama
- Alıntılar otomatik olarak tarayıcıda saklanır
- Sayfa yenilendiğinde alıntılar kaybolmaz
- API anahtarı güvenli şekilde saklanır

### ⌨️ Klavye Kısayolları
- **Ctrl+Enter**: Alıntı ekle
- **Ctrl+S**: Alıntıları kaydet
- **Ctrl+G**: Makale oluştur

### 🔧 Gelişmiş Özellikler
- Drag & drop ile alıntı sıralaması
- Proje dışa/içe aktarma
- Otomatik kaydetme
- Hata mesajları ve bildirimler

## 🛠️ Teknik Detaylar

### Kullanılan Teknolojiler
- **HTML5**: Modern web standartları
- **CSS3**: Flexbox, Grid, Animations
- **Vanilla JavaScript**: ES6+ özellikleri
- **OpenAI API**: GPT-4 Omni entegrasyonu
- **LocalStorage**: Veri saklama

### API Anahtarı Alma
1. [OpenAI](https://platform.openai.com/) sitesine git
2. Hesap oluştur veya giriş yap
3. API Keys bölümünden yeni anahtar oluştur
4. Anahtarı kopyala ve panele yapıştır

### Güvenlik
- API anahtarı sadece tarayıcıda saklanır
- Hiçbir veri sunucuya gönderilmez
- Tüm işlemler yerel olarak çalışır

## 💡 Kullanım İpuçları

### Daha İyi Sonuçlar İçin
1. **Kaliteli alıntılar seç**: Anlamlı ve bağlantılı alıntılar kullan
2. **Sıralamaya dikkat et**: Mantıklı bir akış oluştur
3. **Prompt'u özelleştir**: Kendi yazım tarzını belirt
4. **Çeşitli kaynaklardan alıntı yap**: Zengin içerik oluştur

### Prompt Örnekleri
```
"Romantik ve duygusal bir dille, aşk temasında makale yaz"
"Felsefi derinlikte, düşündürücü bir analiz yap"
"Günlük hayattan örneklerle, sade bir dil kullan"
```

## 🆘 Sorun Giderme

### Yaygın Sorunlar
- **API hatası**: Anahtarın doğru girildiğinden emin ol
- **Makale oluşmuyor**: İnternet bağlantını kontrol et
- **Alıntılar kayboldu**: Tarayıcı geçmişini temizlemiş olabilirsin

### Destek
Herhangi bir sorun yaşarsan, bana ulaşabilirsin! ❤️

## 📝 Sürüm Notları

### v1.0.0
- İlk sürüm
- Temel alıntı ekleme ve makale oluşturma
- 3 farklı yazım stili
- Modern UI/UX tasarımı

---

**Not**: Bu panel sevgilim için özel olarak hazırlandı. Kullanırken keyif al ve güzel makaleler oluştur! 💕
